#ifndef VIDEO_FILTER2D_OUT_H_
#define VIDEO_FILTER2D_OUT_H_

/* ------------------------------------------------------------ */
/*				Include File Definitions						*/
/* ------------------------------------------------------------ */
#include "xil_types.h"
#include "xil_cache.h"
#include "vga_modes.h"
#include "./dynclk/dynclk.h"
#include "xaxivdma.h"
#include "xfilter2d_accel.h"
#include "xvtc.h"
#include "testimg.h"

/* ------------------------------------------------------------ */
/*					Miscellaneous Declarations					*/
/* ------------------------------------------------------------ */
#define DYNCLK_BASEADDR     XPAR_AXI_DYNCLK_0_BASEADDR
#define VGA_VDMA_ID         XPAR_AXIVDMA_0_DEVICE_ID
#define DISP_VTC_ID         XPAR_VTC_0_DEVICE_ID
#define FILTER_ID           XPAR_XFILTER2D_ACCEL_0_DEVICE_ID

#define VGA_PIXEL_BYTE      (4)
#define IMG_PIXEL_BYTE      (3)

#define FILTER_SIZE         (3 * 3)
#define SHIFT               (8)

#define VRAM    ((volatile unsigned char *)  0x10000000)
#define img_in  ((volatile unsigned char *)  0x10200000)
#define img_out ((volatile unsigned char *)  0x10210000)
#define filter  ((volatile unsigned short *) 0x10220000)

#define DISPLAY_NUM_FRAMES  3

/* ------------------------------------------------------------ */
/*                グローバル変数                                 */
/* ------------------------------------------------------------ */
XAxiVdma            vdma_inst;
XVtc                vtc_disp;
XFilter2d_accel     filter2d;

u8      *pFrames[DISPLAY_NUM_FRAMES];

/* ------------------------------------------------------------ */
/*                    グローバル関数                             */
/* ------------------------------------------------------------ */
int dynclk_setting(u32 dynClkAddr, VideoMode vMode);
int VTC_send_setting(XVtc *vtcptr, VideoMode vMode);
int VDMA_send_setting(XAxiVdma *vdmaptr, u8 *framePtr[DISPLAY_NUM_FRAMES], u32 stride, VideoMode vMode);
int filter2d_setting(XFilter2d_accel *filter2d_inst, u32 imgin_adr, u32 filter_adr, u32 imgout_adr);

/************************************************************************/

#endif /* VIDEO_FILTER2D_OUT_H_ */