
#include "video_filter2d_out.h"

/* ------------------------------------------------------------ */
/*                Procedure Definitions                         */
/* ------------------------------------------------------------ */
int main(void)
{
    int Status;

    //-----------------------------------------------------
    /* S. M*/
    //-----------------------------------------------------
    //-----------------------------------------------------
    /* S.1 Filter2d̐ݒ*/
    //-----------------------------------------------------
    // S.1.0 
    Status = XFilter2d_accel_Initialize(&filter2d, FILTER_ID);
    if (Status != XST_SUCCESS)
    {
        xil_printf("Filter 2d Initialization failed %d\r\n", Status);
        return XST_FAILURE;
    }

    // S.1.1 Filter2D̐ݒ
    Status = filter2d_setting(&filter2d, (u32)(img_in), (u32)(filter), (u32)(img_out));
    if (Status != XST_SUCCESS)
    {
        xil_printf("Filtering Setting failed %d\r\n", Status);
        return XST_FAILURE;
    }

    //-----------------------------------------------------
    /* S.2 dynclk ̐ݒ*/
    //-----------------------------------------------------
    Status = dynclk_setting(DYNCLK_BASEADDR, VMODE_640x480);
    if (Status != XST_SUCCESS)
    {
        xil_printf("Dynamic Clock Setting failed %d\r\n", Status);
        return XST_FAILURE;
    }

    //-----------------------------------------------------
    /* S.3 VDMA̓ǂݏo̐ݒ */
    //-----------------------------------------------------
    // S.3.0 
    XAxiVdma_Config *vdmaConfig;
    vdmaConfig = XAxiVdma_LookupConfig(VGA_VDMA_ID);
    if (!vdmaConfig)
    {
        xil_printf("No video DMA found for ID \n");
        return XST_FAILURE;
    }
    
    // S.2 VDMA̓ǂݏoݒ
    // 摜i[t[obt@̃|C^擾
    for (int i = 0; i < DISPLAY_NUM_FRAMES; i++)
    {
        pFrames[i] = (u8*)VRAM;
    }

    Status = XAxiVdma_CfgInitialize(&vdma_inst, vdmaConfig, vdmaConfig->BaseAddress);
    if (Status != XST_SUCCESS)
    {
        xil_printf("VDMA initialization failed %d\r\n", Status);
        return XST_FAILURE;
    }

    // S.3 VDMA̓ǂݏoݒ
    Status = VDMA_send_setting(&vdma_inst, pFrames, VMODE_640x480.width * VGA_PIXEL_BYTE, VMODE_640x480);
    if (Status != XST_SUCCESS)
    {
        xil_printf("VDMA Setting failed %d\r\n", Status);
        return XST_FAILURE;
    }

    //-----------------------------------------------------
    /* S.4 MVTC̐ݒ */
    //-----------------------------------------------------
    // S.4.0 
    XVtc_Config *vtcConfig;
    vtcConfig = XVtc_LookupConfig(DISP_VTC_ID);
    Status = XVtc_CfgInitialize(&vtc_disp, vtcConfig, vtcConfig->BaseAddress);
    if (Status != XST_SUCCESS)
    {
        return XST_FAILURE;
    }
    
    // S.4 MVTC̃^C~O̐ݒ
    Status = VTC_send_setting(&vtc_disp, VMODE_640x480);
    if (Status != XST_SUCCESS)
    {
        return XST_FAILURE;
    }

    //-----------------------------------------------------
    /* S.5 t[obt@ւ̓ */
    //-----------------------------------------------------
    // S.5.0 img_inւ̓
    u32 iPixelAddr3;
    u32 xcoi, ycoi;
    for(xcoi = 0; xcoi < X_BMP_SIZE; xcoi++)
    {
        
        for(ycoi = 0; ycoi < Y_BMP_SIZE; ycoi++)
        {
            iPixelAddr3 = (xcoi + ycoi * X_BMP_SIZE) * IMG_PIXEL_BYTE ;
            img_in[iPixelAddr3]       = bmp_file_array[ycoi][xcoi][0];   //blue
            img_in[iPixelAddr3 + 1]   = bmp_file_array[ycoi][xcoi][1];   //green
            img_in[iPixelAddr3 + 2]   = bmp_file_array[ycoi][xcoi][2];   //red
        }
    }

    // S.5.1 filterւ̓
    filter[0] = 0  << SHIFT;
    filter[1] = 1  << SHIFT;
    filter[2] = 0  << SHIFT;
    filter[3] = 1  << SHIFT;
    filter[4] = -4 << SHIFT;
    filter[5] = 1  << SHIFT;
    filter[6] = 0  << SHIFT;
    filter[7] = 1  << SHIFT;
    filter[8] = 0  << SHIFT;

    // S.5.2 LbVXV
    Xil_DCacheFlush();

    //-----------------------------------------------------
    /* S.6 Filter2D s */
    //-----------------------------------------------------
    XFilter2d_accel_Start(&filter2d);
    while(XFilter2d_accel_IsDone(&filter2d) != 1){};

    //-----------------------------------------------------
    /* S.7 img_outVRAMɊi[ */
    //-----------------------------------------------------
    // S.7.0 VRAMւ̓
    u32 iPixelAddr4;
    u32 xred, yred;
    for(ycoi = 0; ycoi < VMODE_640x480.height; ycoi++)
    {
        for(xcoi = 0; xcoi < VMODE_640x480.width; xcoi++)
        {
            xred = (int)(xcoi * X_BMP_SIZE / VMODE_640x480.width );
            yred = (int)(ycoi * Y_BMP_SIZE / VMODE_640x480.height);
            iPixelAddr4 = (xcoi + ycoi * VMODE_640x480.width) * VGA_PIXEL_BYTE;
            iPixelAddr3 = (xred + yred * X_BMP_SIZE         ) * IMG_PIXEL_BYTE;

            VRAM[iPixelAddr4]       = img_out[iPixelAddr3]    ;   //blue
            VRAM[iPixelAddr4 + 1]   = img_out[iPixelAddr3 + 1];   //green
            VRAM[iPixelAddr4 + 2]   = img_out[iPixelAddr3 + 2];   //red
        }
    }
    // S.7.1 LbVXV
    Xil_DCacheFlush();

    while(1){};

    return 0;
}

//-----------------------------------------------------
/* S.1 filter2d ̐ݒ*/
//-----------------------------------------------------
int filter2d_setting(XFilter2d_accel *filter2d_inst, u32 imgin_adr, u32 filter_adr, u32 imgout_adr)
{
    // S.1.0 Filter2d̃Rg[WX^ւ̓
    //control_s_axi (parameter)
    XFilter2d_accel_Set_shift(filter2d_inst, SHIFT);
    XFilter2d_accel_Set_rows(filter2d_inst, Y_BMP_SIZE);
    XFilter2d_accel_Set_cols(filter2d_inst, X_BMP_SIZE);

    // S.1.1 Filter2d̔z
    //control_r_s_axi (pointer)
    XFilter2d_accel_Set_img_in(filter2d_inst, imgin_adr);
    XFilter2d_accel_Set_filter(filter2d_inst, filter_adr);
    XFilter2d_accel_Set_img_out(filter2d_inst, imgout_adr);

    return  0;
}

//-----------------------------------------------------
/* S.2 dynclk ̐ݒ*/
//-----------------------------------------------------
int dynclk_setting(u32 dynClkAddr, VideoMode vMode)
{
    ClkConfig clkReg;
    ClkMode clkMode;

    ClkFindParams(vMode.freq, &clkMode);

    if (!ClkFindReg(&clkReg, &clkMode))
    {
        xdbg_printf(XDBG_DEBUG_GENERAL, "Error calculating CLK register values\n\r");
        return XST_FAILURE;
    }
    
    ClkWriteReg(&clkReg, dynClkAddr);
    ClkStart(dynClkAddr);

    return XST_SUCCESS;
}

//-----------------------------------------------------
/* S.3 MVDMA̐ݒ */
//-----------------------------------------------------
int VDMA_send_setting(XAxiVdma *vdmaptr, u8 *framePtr[DISPLAY_NUM_FRAMES], u32 stride, VideoMode vMode)
{
    int i;
    int Status;
    XAxiVdma_DmaSetup   vdmasetup;

    // S.3.1 t[ǂݏ̂ɕKvȏݒ
    vdmasetup.FrameDelay                = 0;
    vdmasetup.EnableCircularBuf         = 1;
    vdmasetup.EnableSync                = 0;
    vdmasetup.PointNum                  = 0;
    vdmasetup.EnableFrameCounter        = 0;
    vdmasetup.VertSizeInput             = vMode.height;
    vdmasetup.HoriSizeInput             = (vMode.width) * 4;
    vdmasetup.FixedFrameStoreAddr       = 0;
    vdmasetup.Stride                    = stride;
    for (i = 0; i < DISPLAY_NUM_FRAMES; i++)
    {
        vdmasetup.FrameStoreStartAddr[i]  = (u32)  framePtr[i];
    }

    // S.3.2 VideoDMAǂݏoJn
    Status = XAxiVdma_StartReadFrame(vdmaptr, &vdmasetup);
    if (Status != XST_SUCCESS)
    {
        xil_printf("VDMA Start Read Frame failed %d\r\n", Status);
        return XST_FAILURE;
    }

    // S.3.3 Mt[̃t[(0)ɌŒ
    Status = XAxiVdma_StartParking(vdmaptr, 0, XAXIVDMA_READ);
    if (Status != XST_SUCCESS)
    {
        xil_printf("VDMA Start Parking failed %d\r\n", Status);
        return XST_FAILURE;
    }

    return  XST_SUCCESS;
}

//-----------------------------------------------------
/* S.4 MVTC̐ݒ */
//-----------------------------------------------------
int VTC_send_setting(XVtc *vtcptr, VideoMode vMode)
{
    XVtc_Timing vtcTiming;
    XVtc_SourceSelect SourceSelect;

    // S.4.1 ^C~O𐧌䂷̂ɕKvȏݒ
    vtcTiming.HActiveVideo  = vMode.width                     ;    /**< Horizontal Active Video Size */
    vtcTiming.HFrontPorch   = vMode.hps    - vMode.width      ;    /**< Horizontal Front Porch Size */
    vtcTiming.HSyncWidth    = vMode.hpe    - vMode.hps        ;    /**< Horizontal Sync Width */
    vtcTiming.HBackPorch    = vMode.hmax   - vMode.hpe + 1    ;    /**< Horizontal Back Porch Size */
    vtcTiming.HSyncPolarity = vMode.hpol                      ;    /**< Horizontal Sync Polarity */
    vtcTiming.VActiveVideo  = vMode.height                    ;    /**< Vertical Active Video Size */
    vtcTiming.V0FrontPorch  = vMode.vps    - vMode.height     ;    /**< Vertical Front Porch Size */
    vtcTiming.V0SyncWidth   = vMode.vpe    - vMode.vps        ;    /**< Vertical Sync Width */
    vtcTiming.V0BackPorch   = vMode.vmax   - vMode.vpe + 1    ;    /**< Horizontal Back Porch Size */
    vtcTiming.V1FrontPorch  = vMode.vps    - vMode.height     ;    /**< Vertical Front Porch Size */
    vtcTiming.V1SyncWidth   = vMode.vpe    - vMode.vps        ;    /**< Vertical Sync Width */
    vtcTiming.V1BackPorch   = vMode.vmax   - vMode.vpe + 1    ;    /**< Horizontal Back Porch Size */
    vtcTiming.VSyncPolarity = vMode.vpol                      ;    /**< Vertical Sync Polarity */
    vtcTiming.Interlaced    = 0                               ;    /**< Interlaced / Progressive video */

    memset((void *)&SourceSelect, 0, sizeof(SourceSelect));
    SourceSelect.VBlankPolSrc       = 1;
    SourceSelect.VSyncPolSrc        = 1;
    SourceSelect.HBlankPolSrc       = 1;
    SourceSelect.HSyncPolSrc        = 1;
    SourceSelect.ActiveVideoPolSrc  = 1;
    SourceSelect.ActiveChromaPolSrc = 1;
    SourceSelect.VChromaSrc         = 1;
    SourceSelect.VActiveSrc         = 1;
    SourceSelect.VBackPorchSrc      = 1;
    SourceSelect.VSyncSrc           = 1;
    SourceSelect.VFrontPorchSrc     = 1;
    SourceSelect.VTotalSrc          = 1;
    SourceSelect.HActiveSrc         = 1;
    SourceSelect.HBackPorchSrc      = 1;
    SourceSelect.HSyncSrc           = 1;
    SourceSelect.HFrontPorchSrc     = 1;
    SourceSelect.HTotalSrc          = 1;

    // S.4.2 VTCgUNV̊Jn
    XVtc_SelfTest(vtcptr);
    XVtc_RegUpdateEnable(vtcptr);
    XVtc_SetGeneratorTiming(vtcptr, &vtcTiming);
    XVtc_SetSource(vtcptr, &SourceSelect);
    XVtc_EnableGenerator(vtcptr);

    return XST_SUCCESS;
}